<?php
session_start();
require_once 'database.php';

$statusMessage = '';
$statusClass = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');

    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $statusMessage = 'Please enter a valid email address.';
        $statusClass = 'bg-red-100 border-red-400 text-red-700';
    } else {
        $conn = getDBConnection();
        $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows === 1) {
            $otp = random_int(100000, 999999);
            $otp_expiry = date('Y-m-d H:i:s', strtotime('+10 minutes'));

            $update_stmt = $conn->prepare("UPDATE users SET otp_code = ?, otp_expiry = ? WHERE email = ?");
            $update_stmt->bind_param("sss", $otp, $otp_expiry, $email);

            if ($update_stmt->execute()) {
                // Send OTP email
                $subject = "Your Password Reset OTP";
                $body = "Your OTP for password reset is: <strong>{$otp}</strong>. It will expire in 10 minutes.";
                $sender = 'info@ewusiwahostel.com';

                $headers = "From: Ewusiwa Hostel <{$sender}>\r\n";
                $headers .= "Reply-To: {$sender}\r\n";
                $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

                $message = "
                    <html>
                    <body style='font-family: Inter, Arial, sans-serif; line-height: 1.6; background-color: #f7f9fb; padding: 20px;'>
                        <div style='max-width: 600px; margin: auto; background-color: #ffffff; padding: 30px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); border-top: 4px solid #1e3a8a;'>
                            <h2 style='color: #1e3a8a; margin-top: 0;'>Password Reset Request</h2>
                            <hr style='border: 0; border-top: 1px solid #ddd;'>
                            <p style='color: #333333; font-size: 16px;'>
                                You requested a password reset. Use the One-Time Password (OTP) below to proceed.
                            </p>
                            <div style='margin-top: 20px; padding: 15px; background-color: #f1f5f9; border-left: 5px solid #1e3a8a; border-radius: 4px; text-align: center;'>
                                <p style='font-size: 24px; font-weight: bold; color: #1e3a8a; margin: 0;'>{$otp}</p>
                            </div>
                            <p style='color: #555; font-size: 14px; margin-top: 20px;'>
                                This OTP is valid for 10 minutes. If you did not request a password reset, please ignore this email.
                            </p>
                            <hr style='border: 0; border-top: 1px solid #ddd; margin-top: 20px;'>
                            <p style='font-size: 12px; color: #777;'>
                                This message was sent from {$sender}.
                            </p>
                        </div>
                    </body>
                    </html>
                ";

                if (mail($email, $subject, $message, $headers)) {
                    $_SESSION['reset_email'] = $email;
                    header("Location: auth-boxed-reset-password.php");
                    exit();
                } else {
                    $statusMessage = "Could not send OTP email. Please try again later.";
                    $statusClass = 'bg-red-100 border-red-400 text-red-700';
                }
            } else {
                $statusMessage = "Failed to generate OTP. Please try again.";
                $statusClass = 'bg-red-100 border-red-400 text-red-700';
            }
            $update_stmt->close();
        } else {
            $statusMessage = "No account found with that email address.";
            $statusClass = 'bg-red-100 border-red-400 text-red-700';
        }
        $stmt->close();
        $conn->close();
    }
}
?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Ewusiwa Hostel  Wifi - Forgot Password</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" type="image/x-icon" href="favicon.png">
        <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet">
        <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css">
    </head>

    <body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased">
        <div class="main-container min-h-screen text-black dark:text-white-dark">
            <div class="relative flex min-h-screen items-center justify-center bg-[url(../images/auth/map.png)] bg-cover bg-center bg-no-repeat px-6 py-10 dark:bg-[#060818] sm:px-16">
                <div class="relative w-full max-w-lg rounded-md bg-[linear-gradient(45deg,#fff9f9_0%,rgba(255,255,255,0)_25%,rgba(255,255,255,0)_75%,_#fff9f9_100%)] p-2 dark:bg-[linear-gradient(52.22deg,#0E1726_0%,rgba(14,23,38,0)_18.66%,rgba(14,23,38,0)_51.04%,rgba(14,23,38,0)_80.07%,#0E1726_100%)]">
                    <div class="relative flex flex-col justify-center rounded-md bg-white/60 backdrop-blur-lg dark:bg-black/50 px-6 lg:min-h-[500px] py-20">
                        <div class="mx-auto w-full max-w-[440px]">
                            <div class="mb-10">
                                <h1 class="text-3xl font-extrabold uppercase !leading-snug text-primary md:text-4xl">Forgot Password</h1>
                                <p class="text-base font-bold leading-normal text-white-dark">Enter your email to receive a password reset OTP</p>
                            </div>
                            <?php if ($statusMessage): ?>
                                <div role="alert" class="mb-6 p-4 border rounded-lg font-semibold <?php echo $statusClass; ?>">
                                    <?php echo htmlspecialchars($statusMessage); ?>
                                </div>
                            <?php endif; ?>
                            <form class="space-y-5 dark:text-white" method="post" action="">
                                <div>
                                    <label for="email">Email</label>
                                    <div class="relative text-white-dark">
                                        <input id="email" name="email" type="email" placeholder="Enter Email" class="form-input ps-10 placeholder:text-white-dark" required>
                                        <span class="absolute start-4 top-1/2 -translate-y-1/2">
                                            <svg width="18" height="18" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path opacity="0.5" d="M2 12C2 8.22876 2 6.34315 3.17157 5.17157C4.34315 4 6.22876 4 10 4H14C17.7712 4 19.6569 4 20.8284 5.17157C22 6.34315 22 8.22876 22 12C22 15.7712 22 17.6569 20.8284 18.8284C19.6569 20 17.7712 20 14 20H10C6.22876 20 4.34315 20 3.17157 18.8284C2 17.6569 2 15.7712 2 12Z" stroke="currentColor" stroke-width="1.5"></path>
                                                <path d="M6 8L8.1589 9.79908C9.99553 11.3296 10.9139 12.0949 12 12.0949C13.0861 12.0949 14.0045 11.3296 15.8411 9.79908L18 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-gradient !mt-6 w-full border-0 uppercase shadow-[0_10px_20px_-10px_rgba(67,97,238,0.44)]">
                                    Send OTP
                                </button>
                            </form>
                            <div class="text-center dark:text-white mt-8">
                                Remember your password?
                                <a href="auth-boxed-signin.php" class="uppercase text-primary underline transition hover:text-black dark:hover:text-white">Sign In</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="assets/js/alpine.min.js"></script>
    </body>
</html>