<?php
session_start();
require_once 'database.php';

$statusMessage = '';
$statusClass = '';

if (!isset($_SESSION['reset_email'])) {
    header("Location: auth-boxed-forgot-password.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_SESSION['reset_email'];
    $otp = trim($_POST['otp_code'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    if (empty($otp) || empty($password) || empty($confirm_password)) {
        $statusMessage = 'All fields are required.';
        $statusClass = 'bg-red-100 border-red-400 text-red-700';
    } elseif ($password !== $confirm_password) {
        $statusMessage = 'Passwords do not match.';
        $statusClass = 'bg-red-100 border-red-400 text-red-700';
    } else {
        $conn = getDBConnection();
        $stmt = $conn->prepare("SELECT otp_code, otp_expiry FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows === 1) {
            $stmt->bind_result($db_otp, $db_otp_expiry);
            $stmt->fetch();

            if ($db_otp === $otp && strtotime($db_otp_expiry) > time()) {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $update_stmt = $conn->prepare("UPDATE users SET password = ?, otp_code = NULL, otp_expiry = NULL WHERE email = ?");
                $update_stmt->bind_param("ss", $hashed_password, $email);

                if ($update_stmt->execute()) {
                    unset($_SESSION['reset_email']);
                    $_SESSION['success_message'] = "Password has been reset successfully. You can now log in.";
                    header("Location: auth-boxed-signin.php");
                    exit();
                } else {
                    $statusMessage = "Failed to reset password. Please try again.";
                    $statusClass = 'bg-red-100 border-red-400 text-red-700';
                }
                $update_stmt->close();
            } else {
                $statusMessage = "Invalid or expired OTP.";
                $statusClass = 'bg-red-100 border-red-400 text-red-700';
            }
        } else {
            // This case should ideally not happen if they came from the forgot password page
            $statusMessage = "An error occurred.";
            $statusClass = 'bg-red-100 border-red-400 text-red-700';
        }
        $stmt->close();
        $conn->close();
    }
}
?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Ewusiwa Hostel  Wifi - Reset Password</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" type="image/x-icon" href="favicon.png">
        <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet">
        <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css">
    </head>

    <body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased">
        <div class="main-container min-h-screen text-black dark:text-white-dark">
            <div class="relative flex min-h-screen items-center justify-center bg-[url(../images/auth/map.png)] bg-cover bg-center bg-no-repeat px-6 py-10 dark:bg-[#060818] sm:px-16">
                <div class="relative w-full max-w-lg rounded-md bg-[linear-gradient(45deg,#fff9f9_0%,rgba(255,255,255,0)_25%,rgba(255,255,255,0)_75%,_#fff9f9_100%)] p-2 dark:bg-[linear-gradient(52.22deg,#0E1726_0%,rgba(14,23,38,0)_18.66%,rgba(14,23,38,0)_51.04%,rgba(14,23,38,0)_80.07%,#0E1726_100%)]">
                    <div class="relative flex flex-col justify-center rounded-md bg-white/60 backdrop-blur-lg dark:bg-black/50 px-6 lg:min-h-[500px] py-20">
                        <div class="mx-auto w-full max-w-[440px]">
                            <div class="mb-10">
                                <h1 class="text-3xl font-extrabold uppercase !leading-snug text-primary md:text-4xl">Reset Password</h1>
                                <p class="text-base font-bold leading-normal text-white-dark">Enter the OTP from your email and your new password.</p>
                            </div>
                            <?php if ($statusMessage): ?>
                                <div role="alert" class="mb-6 p-4 border rounded-lg font-semibold <?php echo $statusClass; ?>">
                                    <?php echo htmlspecialchars($statusMessage); ?>
                                </div>
                            <?php endif; ?>
                            <form class="space-y-5 dark:text-white" method="post" action="">
                                <div>
                                    <label for="otp_code">OTP Code</label>
                                    <input id="otp_code" name="otp_code" type="text" placeholder="Enter OTP" class="form-input" required>
                                </div>
                                <div>
                                    <label for="password">New Password</label>
                                    <input id="password" name="password" type="password" placeholder="Enter New Password" class="form-input" required>
                                </div>
                                <div>
                                    <label for="confirm_password">Confirm New Password</label>
                                    <input id="confirm_password" name="confirm_password" type="password" placeholder="Confirm New Password" class="form-input" required>
                                </div>
                                <button type="submit" class="btn btn-gradient !mt-6 w-full border-0 uppercase shadow-[0_10px_20px_-10px_rgba(67,97,238,0.44)]">
                                    Reset Password
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="assets/js/alpine.min.js"></script>
    </body>
</html>