<?php
session_start();
require_once 'dashboard/database.php';

// Fetch packages from the database
$conn = getDBConnection();
$packages = [];
$result = $conn->query("SELECT * FROM hotspot_packages ORDER BY id DESC");
if ($result) {
  while ($row = $result->fetch_assoc()) {
    $packages[] = $row;
  }
}
$conn->close();

// Store in session for later use
$_SESSION['hotspot_packages'] = $packages;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['selected_profile'])) {
  // Always update the transaction_id in session with the new one
  $profile = $_POST['selected_profile'];
  $username = $_POST['username'];
  $momo_number = $_POST['momo_number'];
  $network = $_POST['network'];
  $buyer = isset($_POST['buyer']) ? $_POST['buyer'] : null; // <-- Get buyer value

  // Find package details by profile
  $package = null;
  foreach ($_SESSION['hotspot_packages'] as $p) {
    if ($p['profile'] === $profile) {
      $package = $p;
      break;
    }
  }

  if ($package) {
    // Generate new transaction_id
    $transaction_id = 'Pluto' . str_pad(mt_rand(0, 9999999999999), 13, '0', STR_PAD_LEFT);
    $_SESSION['transaction_id'] = $transaction_id; // <-- Always overwrite with new

    $amount = $package['amount'];
    $limit_uptime = $package['limit_uptime'];
    $limit_bytes_in = $package['limit_bytes_in'];
    $limit_bytes_out = $package['limit_bytes_out'];
    $limit_bytes_total = $package['limit_bytes_total'];
    $status = 'unpaid';
    $source = 'WEB';
    $router = 'CCTU';

    // Set Ghana timezone and get current datetime
    date_default_timezone_set('Africa/Accra');
    $created_at = date('Y-m-d H:i:s');

    $conn = getDBConnection();
    $stmt = $conn->prepare("INSERT INTO transaction_history (username, momo_number, network, buyer, transaction_id, amount, profile, limit_uptime, limit_bytes_in, limit_bytes_out, limit_bytes_total, status, source, router, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param(
      'sssssdsssssssss',
      $username,
      $momo_number,
      $network,
      $buyer, // <-- Add buyer to binding
      $transaction_id,
      $amount,
      $profile,
      $limit_uptime,
      $limit_bytes_in,
      $limit_bytes_out,
      $limit_bytes_total,
      $status,
      $source,
      $router,
      $created_at
    );
    $stmt->execute();
    $stmt->close();
    $conn->close();

    // Prepare data for payment initiation
    $initiateUrl = 'https://plutonetwork.online/accra/emcee_hubtel_initiate_payment.php';
    $callbackUrl = 'https://plutonetwork.online/accra/hubtel_calback.php';

    // Add 6% charge to the amount
    $charged_amount = round($amount * 1.06, 2);

    $postData = [
      'customer_number' => $momo_number,
      'amount' => $amount,
      'transaction_id' => $transaction_id,
      'network_code' => $network,
      'callback_url' => $callbackUrl,
      'description' => 'Pluto LTD' // <-- Added description field
    ];

    // Initiate payment via cURL
    $ch = curl_init($initiateUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Save the response for debugging
    file_put_contents('payment_debug.log', date('Y-m-d H:i:s') . " | Transaction ID: $transaction_id | Response: $response | HTTP Code: $httpCode\n", FILE_APPEND);

    // Update transaction status to pending
    $conn = getDBConnection();
    $stmt = $conn->prepare("UPDATE transaction_history SET status = 'pending' WHERE transaction_id = ?");
    $stmt->bind_param('s', $transaction_id);
    $stmt->execute();
    $stmt->close();
    $conn->close();

    // After updating transaction status to pending
    header('Content-Type: application/json');
    echo json_encode([
      'status' => 'success',
      'title' => 'Payment Initiated',
      'message' => 'Kindly check your phone to approve the payment. Thank you!',
      'transaction_id' => $transaction_id // <-- add this line
    ]);
    exit;
  } else {
    header('Content-Type', 'application/json');
    echo json_encode([
      'status' => 'error',
      'title' => 'Package Not Found',
      'message' => 'The selected package could not be found. Please try again.'
    ]);
    exit;
  }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Pluto WiFi</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="loader_style.css">
  <style>
    body {
      /* Pluto logo: green, yellow, white, black */
      background: linear-gradient(120deg, #0b3c1c 0%, #1e6b3a 60%, #ffd600 100%);
    }

    .modal {
      display: none;
      position: fixed;
      inset: 0;
      background-color: rgba(0, 0, 0, 0.5);
      align-items: center;
      justify-content: center;
    }

    .modal.active {
      display: flex;
    }

    @keyframes bounce-in {
      0% {
        transform: scale(0.7);
        opacity: 0;
      }

      60% {
        transform: scale(1.05);
        opacity: 1;
      }

      80% {
        transform: scale(0.95);
      }

      100% {
        transform: scale(1);
      }
    }

    .animate-bounce-in {
      animation: bounce-in 0.7s cubic-bezier(.68, -0.55, .27, 1.55);
    }

    .loader-circle {
      width: 48px;
      height: 48px;
      border: 6px solid #ffd600;
      border-top: 6px solid #fff;
      border-radius: 50%;
      animation: spin 1s linear infinite;
      margin-bottom: 8px;
    }

    .loader-dot {
      width: 12px;
      height: 12px;
      background: #0b3c1c;
      border-radius: 50%;
      animation: bounce 1s infinite alternate;
      margin: 0 auto;
    }

    @keyframes spin {
      100% {
        transform: rotate(360deg);
      }
    }

    @keyframes bounce {
      0% {
        transform: translateY(0);
      }

      100% {
        transform: translateY(-12px);
      }
    }

    .typing {
      border-right: 2px solid #ffd600;
      animation: blink 1s steps(1) infinite;
    }

    @keyframes blink {
      50% {
        border-color: transparent;
      }
    }

    /* HERO SECTION */
    section.bg-blue-600 {
      background: #0b3c1c !important;
      color: #ffd600 !important;
    }

    section.bg-blue-600 h2 {
      color: #ffd600 !important;
    }

    section.bg-blue-600 p {
      color: #fff !important;
    }

    /* PACKAGE CARDS */
    .bg-white.shadow-lg {
      background: rgba(11, 60, 28, 0.97) !important;
      box-shadow: 0 8px 32px 0 rgba(11, 60, 28, 0.25), 0 2px 16px 0 #ffd60033 !important;
      border-radius: 28px !important;
      border: 2px solid #ffd60022 !important;
    }

    .text-blue-600,
    .font-semibold.text-blue-600 {
      color: #ffd600 !important;
    }

    .text-red-600,
    .font-bold.text-red-600 {
      /* Make amounts highly visible: bright yellow with dark shadow for contrast */
      color: #ffd600 !important;
      text-shadow: 0 2px 8px #0b3c1c88, 0 1px 0 #fff;
    }

    .bg-blue-600 {
      background: linear-gradient(90deg, #ffd600 0%, #0b3c1c 100%) !important;
      color: #0b3c1c !important;
    }

    .bg-red-600 {
      background: linear-gradient(90deg, #ffd600 0%, #1e6b3a 100%) !important;
      color: #0b3c1c !important;
    }

    .bg-blue-700,
    .hover\:bg-blue-700:hover {
      background: linear-gradient(90deg, #0b3c1c 0%, #ffd600 100%) !important;
    }

    .bg-red-700,
    .hover\:bg-red-700:hover {
      background: linear-gradient(90deg, #1e6b3a 0%, #ffd600 100%) !important;
    }

    .text-gray-700,
    .text-gray-800,
    .text-gray-600 {
      color: #fff !important;
    }

    input,
    select {
      background: rgba(255, 255, 255, 0.10) !important;
      color: #fff !important;
      border: 2px solid #ffd600 !important;
      border-radius: 14px !important;
    }

    input::placeholder {
      color: #fff !important;
      opacity: 1 !important;
    }

    label {
      color: #ffd600 !important;
      font-weight: 600 !important;
    }

    footer.bg-blue-600 {
      background: #0b3c1c !important;
      color: #ffd600 !important;
    }

    button,
    .rounded,
    .rounded-full {
      border-radius: 22px !important;
      font-weight: 800 !important;
      font-size: 18px !important;
      box-shadow: 0 4px 24px #ffd60033, 0 2px 8px #0b3c1c22 !important;
      transition: transform 0.2s, box-shadow 0.2s, background 0.2s !important;
    }

    button:hover,
    .hover\:bg-blue-700:hover,
    .hover\:bg-red-700:hover {
      transform: translateY(-2px) scale(1.04) !important;
      background: linear-gradient(90deg, #0b3c1c 0%, #ffd600 100%) !important;
      box-shadow: 0 8px 32px #ffd60033 !important;
    }

    .modal .bg-white {
      background: rgba(11, 60, 28, 0.98) !important;
      color: #fff !important;
    }

    .animate-bounce-in {
      box-shadow: 0 8px 32px 0 rgba(11, 60, 28, 0.25), 0 2px 16px 0 #ffd60033 !important;
    }

    #modalPackageDesc {
      color: #ffd600 !important;
    }

    ::-webkit-scrollbar-thumb {
      background: #ffd600 !important;
    }

    ::-webkit-scrollbar-track {
      background: #0b3c1c !important;
    }

    /* Fix for payment prompt text colors */
    #paymentPromptModal .text-gray-700 {
      color: #374151 !important;
      /* Original gray-700 color */
    }

    #paymentPromptModal .text-blue-700 {
      color: #1d4ed8 !important;
      /* Original blue-700 color */
    }

    #generalModal .text-gray-700 {
      color: #374151 !important;
    }

    #generalModal .text-blue-700 {
      color: #1d4ed8 !important;
    }

    /* Success state should remain green */
    #paymentPromptModal .text-green-600 {
      color: #16a34a !important;
    }

    /* Error state should remain red */
    #paymentPromptModal .text-red-600 {
      color: #dc2626 !important;
    }
  </style>
</head>

<body class="font-sans text-gray-800">
  <!-- Header -->
  <!-- <header class="bg-white text-gray-800 py-4 shadow-md">
        <div class="container mx-auto px-4 flex justify-between items-center">
            <h1 class="text-2xl font-bold">Pluto WiFi</h1>
            <nav>
                <a href="#packages" class="hover:underline mx-2">Packages</a>
                <a href="#buy" class="hover:underline mx-2">Buy Now</a>
            </nav>
        </div>
    </header> -->

  <!-- The Loader Element (Unchanged) -->
  <div class="loader">
    <img src="pluto.jpg" alt="Loading...">
  </div>

  <!-- Hero Section -->
  <section class="bg-blue-600 text-white py-12">
    <div class="container mx-auto px-4">
      <div class="flex flex-col md:flex-row items-center">
        <div class="md:w-1/4 flex justify-center md:justify-start mb-6 md:mb-0">
          <img src="pluto.jpg" alt="Pluto WiFi" class="w-32 h-32 object-contain rounded-lg">
        </div>
        <div class="md:w-3/4 flex flex-col items-center">
          <h2 class="text-4xl font-bold mb-4 text-center">PLUTO NETWORKS</h2>
          <p class="text-lg text-center">Enjoy seamless browsing with Pluto WiFi’s low-cost, unlimited internet packages.</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Packages Section -->
  <section id="packages" class="py-12">
    <div class="container mx-auto px-4">
      <h2 class="text-3xl font-bold text-center text-red-600 mb-8">AVAILABLE PACKAGES</h2>
      <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Package Cards -->
        <?php foreach ($packages as $package): ?>
          <div class="bg-white shadow-lg rounded-lg p-6 text-center">
            <h3 class="text-xl font-semibold text-blue-600">
              <?php echo htmlspecialchars($package['description']); ?>
            </h3>
            <p class="text-gray-600">
              <?php
              $details = [];
              if ($package['limit_uptime']) $details[] = "Uptime: " . htmlspecialchars($package['limit_uptime']);
              if ($package['limit_bytes_total']) $details[] = "Total: " . htmlspecialchars($package['limit_bytes_total']) . " bytes";
              if ($package['limit_bytes_in']) $details[] = "In: " . htmlspecialchars($package['limit_bytes_in']) . " bytes";
              if ($package['limit_bytes_out']) $details[] = "Out: " . htmlspecialchars($package['limit_bytes_out']) . " bytes";
              echo implode(' | ', $details);
              ?>
            </p>
            <p class="text-2xl font-bold text-red-600 my-4">
              Ghs <?php echo number_format($package['amount'], 2); ?>
            </p>
            <button
              onclick="openModal('<?php echo htmlspecialchars($package['profile']); ?>')"
              class="bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700">
              Buy Now
            </button>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </section>

  <!-- Modal for Buying Package -->
  <div id="buyModal" class="modal">
    <div class="bg-white p-8 rounded-lg w-full max-w-md">
      <div class="flex justify-between items-center mb-4">
        <h2 class="text-2xl font-bold text-blue-600">Buy Package</h2><br>
        <button onclick="closeModal()" class="text-gray-600 text-2xl">&times;</button>
      </div>
      <form id="paymentForm" method="POST" autocomplete="off">
        <input type="hidden" name="selected_profile" id="selected_profile">
        <div class="mb-2">
          <label class="block text-sm font-medium text-gray-700">Package</label>
          <div id="modalPackageDesc" class="font-semibold text-blue-600"></div><br>
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700">MOBILE MONEY NUMBER (e.g.: 05xxxxxxxx)</label>
          <input type="text" name="momo_number" id="momo_number" class="w-full p-2 border rounded" required> <br><br><br>
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700">MOBILE MONEY NETWORK</label>
          <select name="network" class="w-full p-2 border rounded" required><br><br><br>
            <option value="mtn-gh">MTN</option>
            <option value="vodafone-gh">TELECEL</option>
            <option value="tigo-gh">AT</option>
          </select><br><br><br>
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700">Who are you buying for?</label>
          <select name="buyer" id="buyer" class="w-full p-2 border rounded" required>
            <option value="">Select</option>
            <option value="self">Self</option>
            <option value="others">Others</option>
          </select><br><br><br>
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700">NUMBER TO RECEIVE PASSWORD</label>
          <input type="text" name="username" id="username" class="w-full p-2 border rounded" required><br><br><br>
        </div>
        <button type="submit" class="bg-red-600 text-white py-2 px-4 rounded hover:bg-red-700 w-full mt-2">PAY</button>
      </form>
    </div>
  </div>

  <!-- Payment Prompt Modal -->
  <div id="paymentPromptModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
    <div class="bg-white rounded-2xl shadow-2xl p-8 max-w-sm w-full flex flex-col items-center animate-bounce-in">
      <!-- Loader Animation -->
      <div id="loader" class="mb-4">
        <div class="loader-circle"></div>
        <div class="loader-dot"></div>
      </div>
      <h3 id="promptTitle" class="text-2xl font-bold text-blue-700 mb-2">Approve Payment</h3>
      <p id="promptMessage" class="text-gray-700 text-center mb-4"></p>
      <div id="transactionIdDisplay" class="text-xs text-gray-500 mb-2"></div> <!-- Transaction ID display -->
      <button id="promptBtn" onclick="closePaymentPrompt()" class="mt-2 px-6 py-2 bg-blue-600 text-white rounded-full font-semibold shadow hover:bg-blue-700 transition hidden">OK</button>
    </div>
  </div>

  <!-- General Purpose Animated Modal -->
  <div id="generalModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
    <div class="bg-white rounded-2xl shadow-2xl p-8 max-w-sm w-full flex flex-col items-center animate-bounce-in">
      <div id="generalModalIcon" class="mb-4"></div>
      <h3 id="generalModalTitle" class="text-2xl font-bold text-blue-700 mb-2"></h3>
      <p id="generalModalMessage" class="text-gray-700 text-center mb-4"></p>
      <button onclick="closeGeneralModal()" class="mt-2 px-6 py-2 bg-blue-600 text-white rounded-full font-semibold shadow hover:bg-blue-700 transition">OK</button>
    </div>
  </div>

  <!-- Footer -->
  <footer class="bg-blue-600 text-white py-4">
    <div class="container mx-auto px-4 text-center">
      <p>&copy; 2025 Pluto WiFi. All rights reserved.</p>
    </div>
  </footer>
  <!-- Chatbot Container -->
  <div style="position: fixed; bottom: 20px; right: 20px; z-index: 1000;">
    <!-- Chat Icon (visible by default) -->
    <div id="chatbot-icon" style="cursor: pointer; background: #a18fff; width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center; box-shadow: 0 4px 12px rgba(0,0,0,0.2);">
      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
      </svg>
    </div>

    <!-- Iframe (hidden by default) -->
    <iframe id="chatbot-iframe" src="index7.html" width="350" height="500" frameborder="0" style="border-radius: 10px; box-shadow: 0 0 20px rgba(0,0,0,0.2); display: none;"></iframe>
  </div>

  <script>
    document.getElementById('chatbot-icon').addEventListener('click', function() {
      const iframe = document.getElementById('chatbot-iframe');
      iframe.style.display = iframe.style.display === 'none' ? 'block' : 'none';
    });
  </script>

  <script src="loader_script.js"></script>

  <script>
    const packages = <?php echo json_encode($packages); ?>;
    let selectedProfile = null;

    function openModal(profile) {
      selectedProfile = profile;
      document.getElementById('selected_profile').value = profile;
      // Find the package by profile
      const pkg = packages.find(p => p.profile === profile);
      document.getElementById('modalPackageDesc').innerText = pkg ? pkg.description : '';
      document.getElementById('buyModal').classList.add('active');
    }

    function closeModal() {
      document.getElementById('buyModal').classList.remove('active');
    }
    window.addEventListener('click', function(event) {
      const modal = document.getElementById('buyModal');
      if (event.target === modal) {
        closeModal();
      }
    });

    function showPaymentPrompt() {
      document.getElementById('paymentPromptModal').classList.remove('hidden');
      document.getElementById('promptBtn').classList.add('hidden');
      document.getElementById('promptTitle').innerText = "Approve Payment";
      document.getElementById('loader').style.display = "block";

      // Use class-based styling instead of inline styles
      const promptMessage = document.getElementById('promptMessage');
      promptMessage.classList.remove('text-green-600', 'text-red-600');
      promptMessage.classList.add('text-blue-700');

      typeMessage(
        promptMessage,
        "Please enter your momo pin in the prompt to approve your payment..."
      );
      // Display transaction ID for confirmation
      document.getElementById('transactionIdDisplay').innerText = currentTransactionId ? `Transaction ID: ${currentTransactionId}` : '';
      pollPaymentStatus();
    }

    function closePaymentPrompt() {
      document.getElementById('paymentPromptModal').classList.add('hidden');
      window.location.href = 'http://plutonetwork.me';
    }

    function showGeneralModal({
      title = '',
      message = '',
      icon = ''
    }) {
      document.getElementById('generalModalTitle').innerText = title;
      document.getElementById('generalModalMessage').innerHTML = message;
      document.getElementById('generalModalIcon').innerHTML = icon;
      document.getElementById('generalModal').classList.remove('hidden');
    }

    function closeGeneralModal() {
      document.getElementById('generalModal').classList.add('hidden');
    }
    let currentTransactionId = null;

    let paymentInProgress = false;

    document.getElementById('paymentForm').addEventListener('submit', function(e) {
      e.preventDefault();
      if (paymentInProgress) return; // Prevent double submission
      paymentInProgress = true;

      const form = e.target;
      const formData = new FormData(form);

      // Save "Number to Receive Data" as username in localStorage
      const username = form.username.value;
      localStorage.setItem('username', username);

      fetch(window.location.href, {
          method: 'POST',
          body: formData
        })
        .then(response => response.json())
        .then(data => {
          paymentInProgress = false;
          if (data.status === 'error') {
            showGeneralModal({
              title: data.title,
              message: data.message,
              icon: `<svg class="w-16 h-16 text-red-500 animate-pulse" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" fill="none"/><path stroke-linecap="round" stroke-linejoin="round" d="M15 9l-6 6m0-6l6 6"/></svg>`
            });
            return;
          }
          currentTransactionId = data.transaction_id; // <-- Always set here!
          closeModal();
          showPaymentPrompt();
        })
        .catch(() => {
          paymentInProgress = false;
          showGeneralModal({
            title: "Error",
            message: "Something went wrong. Please try again.",
            icon: `<svg class="w-16 h-16 text-red-500 animate-pulse" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" fill="none"/><path stroke-linecap="round" stroke-linejoin="round" d="M15 9l-6 6m0-6l6 6"/></svg>`
          });
        });
    });

    function showCustomAlert(message, callback) {
      // Create modal if not exists
      let modal = document.getElementById('customAlertModal');
      if (!modal) {
        modal = document.createElement('div');
        modal.id = 'customAlertModal';
        modal.style.position = 'fixed';
        modal.style.top = '0';
        modal.style.left = '0';
        modal.style.width = '100vw';
        modal.style.height = '100vh';
        modal.style.background = 'rgba(0,0,0,0.5)';
        modal.style.display = 'flex';
        modal.style.alignItems = 'center';
        modal.style.justifyContent = 'center';
        modal.style.zIndex = '9999';
        modal.innerHTML = `
          <div style="background:#fff; border-radius:18px; padding:32px 24px; max-width:350px; width:90%; box-shadow:0 8px 32px #ffd60033; text-align:center;">
            <div style="font-size:22px; color:#dc2626; font-weight:700; margin-bottom:18px;">
              <svg style="width:40px;height:40px;margin-bottom:8px;" fill="none" stroke="#dc2626" stroke-width="2" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" stroke="#dc2626" stroke-width="2" fill="none"/><path stroke-linecap="round" stroke-linejoin="round" d="M15 9l-6 6m0-6l6 6"/></svg>
              Error
            </div>
            <div style="color:#374151; font-size:17px; margin-bottom:24px;">${message}</div>
            <button id="customAlertOkBtn" style="background:#ffd600; color:#0b3c1c; font-weight:700; border:none; border-radius:14px; padding:10px 32px; font-size:16px; cursor:pointer;">OK</button>
          </div>
        `;
        document.body.appendChild(modal);
      } else {
        modal.querySelector('div > div:nth-child(2)').innerText = message;
        modal.style.display = 'flex';
      }
      document.getElementById('customAlertOkBtn').onclick = function() {
        modal.style.display = 'none';
        if (callback) callback();
      };
    }

    document.getElementById('buyer').addEventListener('change', function() {
      const buyerValue = this.value;
      const momoInput = document.getElementById('momo_number');
      const usernameInput = document.getElementById('username');
      if (buyerValue === 'self') {
        if (!momoInput.value.trim()) {
          showCustomAlert('Please enter your MOBILE MONEY NUMBER.', function() {
            document.getElementById('buyer').value = '';
            momoInput.focus();
          });
          return;
        }
        usernameInput.value = momoInput.value;
        usernameInput.readOnly = true;
      } else {
        usernameInput.value = '';
        usernameInput.readOnly = false;
      }
    });

    document.getElementById('paymentForm').addEventListener('submit', function(e) {
      const buyerValue = document.getElementById('buyer').value;
      const momoInput = document.getElementById('momo_number');
      const usernameInput = document.getElementById('username');
      if (buyerValue === 'self') {
        if (!momoInput.value.trim()) {
          e.preventDefault();
          showCustomAlert('Please enter your MOBILE MONEY NUMBER.', function() {
            momoInput.focus();
          });
          return;
        }
        usernameInput.value = momoInput.value;
      }
      // ...existing code...
    });

    let typingTimeout = null;

    function typeMessage(element, message, speed = 40, callback) {
      if (typingTimeout) clearTimeout(typingTimeout); // Cancel previous typing
      let i = 0;
      element.innerHTML = '';

      function type() {
        if (i < message.length) {
          element.innerHTML += message.charAt(i);
          element.classList.add('typing');
          i++;
          typingTimeout = setTimeout(type, speed);
        } else {
          element.classList.remove('typing');
          typingTimeout = null;
          if (callback) callback();
        }
      }
      type();
    }

    function showPaymentPrompt() {
      document.getElementById('paymentPromptModal').classList.remove('hidden');
      document.getElementById('promptBtn').classList.add('hidden');
      document.getElementById('promptTitle').innerText = "Approve Payment";
      document.getElementById('loader').style.display = "block";

      // Use class-based styling instead of inline styles
      const promptMessage = document.getElementById('promptMessage');
      promptMessage.classList.remove('text-green-600', 'text-red-600');
      promptMessage.classList.add('text-blue-700');

      typeMessage(
        promptMessage,
        "Please enter your momo pin in the prompt to approve your payment..."
      );
      // Display transaction ID for confirmation
      document.getElementById('transactionIdDisplay').innerText = currentTransactionId ? `Transaction ID: ${currentTransactionId}` : '';
      pollPaymentStatus();
    }

    function pollPaymentStatus() {
      if (!currentTransactionId) {
        logFrontendStep('no_transaction_id', 'Transaction ID missing');
        return;
      }

      let countdownInterval = null;
      let countdown = 15;
      let lastStatus = "";

      function updateCountdown() {
        logFrontendStep('countdown', `Countdown: ${countdown}`);
        document.getElementById('promptTitle').innerText = "Payment Successful";
        document.getElementById('loader').style.display = "none";

        // Use class-based styling for success message (green)
        const promptMessage = document.getElementById('promptMessage');
        promptMessage.classList.remove('text-green-600', 'text-red-600', 'text-blue-700');
        promptMessage.classList.add('text-green-600');

        promptMessage.innerText = `Payment successful... Connecting you to Pluto Wifi in ${countdown}s...`;
        countdown--;
        if (countdown < 0) {
          clearInterval(countdownInterval);
        }
      }

      function checkStatus() {
        logFrontendStep('check_status_start', `Checking status for transaction_id: ${currentTransactionId}`);
        fetch('check_status.php?transaction_id=' + encodeURIComponent(currentTransactionId))
          .then(res => res.json())
          .then(async data => {
            logFrontendStep('status_response', JSON.stringify(data));
            const promptMessage = document.getElementById('promptMessage');

            if (data.status === 'unpaid') {
              logFrontendStep('status_unpaid', 'Status is unpaid');
              document.getElementById('promptTitle').innerText = "Initiating Payment";
              document.getElementById('loader').style.display = "block";

              // Use class-based styling
              promptMessage.classList.remove('text-green-600', 'text-red-600', 'text-blue-700');
              promptMessage.classList.add('text-gray-700');
              promptMessage.innerText = "Initiating payment please wait...";
              setTimeout(checkStatus, 2000); // <-- keep polling
            } else if (data.status === 'pending') {
              logFrontendStep('status_pending', 'Status is pending');
              document.getElementById('promptTitle').innerText = "Approve Payment";
              document.getElementById('loader').style.display = "block";

              // Use class-based styling
              promptMessage.classList.remove('text-green-600', 'text-red-600', 'text-gray-700');
              promptMessage.classList.add('text-blue-700');
              promptMessage.innerText = "Please enter your momo pin in the prompt to approve your payment...";
              setTimeout(checkStatus, 2000); // <-- keep polling
            } else if (data.status.toLowerCase() === 'paid') {
              logFrontendStep('status_paid', 'Status is paid, checking account');
              let account = await fetch('get_account.php?transaction_id=' + encodeURIComponent(currentTransactionId)).then(r => r.json());
              logFrontendStep('account_response', JSON.stringify(account));
              if (account.username && account.password) {
                logFrontendStep('account_found', `Redirecting with username: ${account.username}`);
                document.getElementById('loader').style.display = "none";
                document.getElementById('promptBtn').classList.add('hidden');
                countdown = 15;
                updateCountdown();
                countdownInterval = setInterval(() => {
                  updateCountdown();
                  if (countdown < 0) {
                    if (account.buyer === "self") {
                      window.location.href = `http://plutonetwork.me/login.html?username=${encodeURIComponent(account.username)}&password=${encodeURIComponent(account.password)}`;
                    } else if (account.buyer === "others") {
                      window.location.href = "https://plutonetwork.online/paid.php";
                    } else {
                      window.location.href = "http://plutonetwork.me"; // fallback
                    }
                  }
                }, 1000);
              } else {
                logFrontendStep('account_not_found', 'Account not found, polling again');
                setTimeout(checkStatus, 2000);
              }
            } else if (data.status.toLowerCase() === 'failed') {
              logFrontendStep('status_failed', 'Status is failed');
              document.getElementById('loader').style.display = "none";
              document.getElementById('promptTitle').innerText = "Payment Failed";

              // Use class-based styling for error (red)
              promptMessage.classList.remove('text-green-600', 'text-blue-700', 'text-gray-700');
              promptMessage.classList.add('text-red-600');
              promptMessage.innerText = "Payment failed... Please try again or contact support: 0551387568";
              document.getElementById('promptBtn').classList.remove('hidden');
            } else {
              logFrontendStep('status_unknown', `Unknown status: ${data.status}`);
              setTimeout(checkStatus, 2000); // <-- keep polling for unknown status
            }
          })
          .catch((err) => {
            logFrontendStep('status_error', err.toString());
            setTimeout(checkStatus, 2000); // <-- keep polling on error
          });
      }
      checkStatus();
    }

    function logFrontendStep(step, info) {
      fetch('frontend_log.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: `step=${encodeURIComponent(step)}&info=${encodeURIComponent(info)}`
      });
    }
  </script>

  <!-- Chatbot START -->
  <div id="chatbot-container" style="position: fixed; bottom: 80px; right: 20px; z-index: 1000; display: none;">
    <iframe src="chat_bot.php" width="350" height="550" frameborder="0"
      style="border-radius: 10px; box-shadow: 0 0 20px rgba(0,0,0,0.2);"></iframe>
  </div>

  <div id="chatbot-toggle"
    style="position: fixed; bottom: 20px; right: 20px; background: linear-gradient(135deg, #0078d4 60%, #00cfff 100%);
           border-radius: 50%; width: 60px; height: 60px; display: flex; justify-content: center; align-items: center;
           cursor: pointer; box-shadow: 0 4px 16px rgba(0,0,0,0.18); z-index: 1001;">
    <svg id="chatbot-icon" viewBox="0 0 48 48" fill="none" width="38" height="38">
      <!-- Original bubble icon -->
      <defs>
        <linearGradient id="bubbleGradient" x1="0" y1="0" x2="48" y2="48" gradientUnits="userSpaceOnUse">
          <stop stop-color="#00cfff" />
          <stop offset="1" stop-color="#0078d4" />
        </linearGradient>
      </defs>
      <ellipse cx="24" cy="24" rx="20" ry="18" fill="url(#bubbleGradient)" />
      <ellipse cx="24" cy="24" rx="20" ry="18" fill="url(#bubbleGradient)" opacity="0.15" />
      <path d="M24 38c-7.732 0-14-5.373-14-12s6.268-12 14-12 14 5.373 14 12c0 2.13-.73 4.13-2.02 5.84-.39.53-.51 1.22-.31 1.85l1.13 3.39c.34 1.01-.66 1.93-1.65 1.54l-3.39-1.13c-.63-.21-1.32-.08-1.85.31C28.13 37.27 26.13 38 24 38z" fill="#fff" stroke="#0078d4" stroke-width="2" />
      <circle cx="19" cy="24" r="2" fill="#0078d4" />
      <circle cx="29" cy="24" r="2" fill="#0078d4" />
      <path d="M20.5 28c1.5 1.5 5.5 1.5 7 0" stroke="#0078d4" stroke-width="2" stroke-linecap="round" />
    </svg>
  </div>

  <script>
    const toggleBtn = document.getElementById('chatbot-toggle');
    const chatbot = document.getElementById('chatbot-container');
    const icon = document.getElementById('chatbot-icon');

    const bubbleIcon = icon.innerHTML; // store original
    const closeIcon = '<line x1="12" y1="12" x2="36" y2="36" stroke="#fff" stroke-width="4" stroke-linecap="round" />' +
      '<line x1="36" y1="12" x2="12" y2="36" stroke="#fff" stroke-width="4" stroke-linecap="round" />';

    toggleBtn.addEventListener('click', function() {
      if (chatbot.style.display === 'none') {
        chatbot.style.display = 'block';
        icon.innerHTML = closeIcon; // show X
      } else {
        chatbot.style.display = 'none';
        icon.innerHTML = bubbleIcon; // restore bubble
      }
    });
  </script>
  <!-- Chatbot END -->

</body>

</html>