<?php
// check_status.php
require_once 'dashboard/database.php';
$transaction_id = $_GET['transaction_id'] ?? '';
$conn = getDBConnection();
$stmt = $conn->prepare("SELECT status FROM transaction_history WHERE transaction_id = ?");
$stmt->bind_param('s', $transaction_id);
$stmt->execute();
$stmt->bind_result($status);
$stmt->fetch();
$stmt->close();
$conn->close();

$status = strtolower(trim($status ?? 'pending'));
$valid_statuses = ['unpaid', 'pending', 'paid', 'failed']; // <-- all lowercase
if (!in_array($status, $valid_statuses)) {
    $status = 'pending';
}

// Log every status check
$log_line = date('Y-m-d H:i:s') . " | transaction_id: $transaction_id | status: $status\n";
file_put_contents('status_debug.log', $log_line, FILE_APPEND);

echo json_encode(['status' => $status]);