<?php
// update_users.php
require_once 'database.php';

// 🔹 Log raw request for debugging
file_put_contents('debug_users.txt', json_encode($_GET) . PHP_EOL, FILE_APPEND);

// --- New: Router name ---
$router_name = $_GET['router_name'] ?? '';

// --- Existing Data ---
$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$profile = $_GET['profile'] ?? '';
$uptime = $_GET['uptime'] ?? '';
$bytes_in = $_GET['bytes_in'] ?? $_GET['bytesIn'] ?? 0;
$bytes_out = $_GET['bytes_out'] ?? $_GET['bytesOut'] ?? 0;
$mac_address = $_GET['mac_address'] ?? '';
$server = $_GET['server'] ?? '';
$disabled = $_GET['disabled'] ?? 0;
$comment = $_GET['comment'] ?? '';

// NEW: Receive limit data from the URL
$limit_uptime = $_GET['limit_uptime'] ?? '';
$limit_bytes_in = $_GET['limit_bytes_in'] ?? 0;
$limit_bytes_out = $_GET['limit_bytes_out'] ?? 0;
$limit_bytes_total = $_GET['limit_bytes_total'] ?? 0;
$rate_limit = $_GET['rate_limit'] ?? '';

// --- Formatting ---
$bytes_in_mb = round($bytes_in / 1048576, 2) . ' MB';
$bytes_out_mb = round($bytes_out / 1048576, 2) . ' MB';
$total_bandwidth_gb = round((($bytes_in + $bytes_out) / 1073741824), 2) . ' GB';

// Format limit data
$limit_bytes_in_mb = ($limit_bytes_in > 0) ? round($limit_bytes_in / 1048576, 2) . ' MB' : '0';
$limit_bytes_out_mb = ($limit_bytes_out > 0) ? round($limit_bytes_out / 1048576, 2) . ' MB' : '0';
$limit_bytes_total_gb = ($limit_bytes_total > 0) ? round($limit_bytes_total / 1073741824, 2) . ' GB' : '0';

if ($router_name !== '' && $username !== '') {
    $conn = getDBConnection();

    // --- Upsert main table (latest state per user per router) ---
    $stmt = $conn->prepare("INSERT INTO hotspot_users (router_name, username, password, profile, uptime, bytes_in, bytes_out, total_bandwidth_gb, mac_address, server, disabled, comment, limit_uptime, limit_bytes_in, limit_bytes_out, limit_bytes_total, rate_limit)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
            password=VALUES(password),
            profile=VALUES(profile),
            uptime=VALUES(uptime),
            bytes_in=VALUES(bytes_in),
            bytes_out=VALUES(bytes_out),
            total_bandwidth_gb=VALUES(total_bandwidth_gb),
            mac_address=VALUES(mac_address),
            server=VALUES(server),
            disabled=VALUES(disabled),
            comment=VALUES(comment),
            limit_uptime=VALUES(limit_uptime),
            limit_bytes_in=VALUES(limit_bytes_in),
            limit_bytes_out=VALUES(limit_bytes_out),
            limit_bytes_total=VALUES(limit_bytes_total),
            rate_limit=VALUES(rate_limit)
    ");
    $stmt->bind_param(
        'ssssssssssissssss',
        $router_name, $username, $password, $profile, $uptime,
        $bytes_in_mb, $bytes_out_mb, $total_bandwidth_gb, $mac_address,
        $server, $disabled, $comment, $limit_uptime,
        $limit_bytes_in_mb, $limit_bytes_out_mb, $limit_bytes_total_gb, $rate_limit
    );
    $stmt->execute();
    $stmt->close();

    // --- History table (append only) ---
    $stmt2 = $conn->prepare("INSERT INTO hotspot_users_history (router_name, username, password, profile, uptime, bytes_in, bytes_out, total_bandwidth_gb, mac_address, server, disabled, comment, limit_uptime, limit_bytes_in, limit_bytes_out, limit_bytes_total, rate_limit)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt2->bind_param(
        'ssssssssssissssss',
        $router_name, $username, $password, $profile, $uptime,
        $bytes_in_mb, $bytes_out_mb, $total_bandwidth_gb, $mac_address,
        $server, $disabled, $comment, $limit_uptime,
        $limit_bytes_in_mb, $limit_bytes_out_mb, $limit_bytes_total_gb, $rate_limit
    );
    $stmt2->execute();
    $stmt2->close();

    $conn->close();
    echo "OK";
} else {
    echo "Missing router_name or username";
}
?>
