<?php
session_start();
require_once '../database.php'; // Adjust path as needed

define('INACTIVITY_LIMIT', 900); // 15 minutes

// Logout if inactive
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > INACTIVITY_LIMIT)) {
    session_unset();
    session_destroy();
    header("Location: ../auth-boxed-signin.html?timeout=1");
    exit();
}
$_SESSION['last_activity'] = time();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = $_POST['phone_number'] ?? '';
    $password = $_POST['password'] ?? '';

    if (empty($phone) || empty($password)) {
        echo "Phone number and password are required.";
        exit();
    }

    // Prepare and execute query
    $stmt = $conn->prepare("SELECT * FROM users WHERE phone_number = ?");
    $stmt->bind_param("s", $phone);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['phone_number'] = $user['phone_number'];
        $_SESSION['last_activity'] = time();
        header("Location: ../index.html");
        exit();
    } else {
        echo "Invalid phone number or password.";
    }
}
?>
<!-- Simple HTML form for login -->
<form method="POST">
    <input type="text" name="phone_number" placeholder="Phone Number" required>
    <input type="password" name="password" placeholder="Password" required>
    <button type="submit">Sign In</button>
</form>